/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.security;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.IVWRecipientSelectionPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWItemFilterPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientListCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VWRecipientFilterPanel
extends JPanel
implements IVWRecipientSelectionPanel,
ActionListener,
ListSelectionListener,
FocusListener {
    public static final String ACMD_SELECTION_CHANGED = "SelectionChanged";
    private Container m_parentContainer = null;
    private VWSession m_vwSession = null;
    private EventListenerList m_listenerList = null;
    private VWItemFilterPanel m_itemFilterPanel = null;
    private JList m_resultsList = null;

    public VWRecipientFilterPanel(Container parentContainer, VWSession vwSession) {
        this.m_parentContainer = parentContainer;
        this.m_vwSession = vwSession;
        this.m_listenerList = new EventListenerList();
        this.init();
    }

    public JList getRecipientFilterJList() {
        return this.m_resultsList;
    }

    public void addActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.add(ActionListener.class, listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.remove(ActionListener.class, listener);
        }
    }

    public int getItemCount() {
        if (this.m_resultsList != null) {
            return this.m_resultsList.getModel().getSize();
        }
        return -1;
    }

    public VWParticipant getSelectedValue() {
        Object value;
        if (this.m_resultsList != null && (value = this.m_resultsList.getSelectedValue()) != null && value instanceof VWParticipantItem) {
            return ((VWParticipantItem)value).getVWParticipant();
        }
        return null;
    }

    public void setSelectedValue(VWParticipant recipient) {
        if (this.m_resultsList != null && recipient != null) {
            boolean bFound = false;
            if (this.getItemCount() > 0) {
                for (int i = 0; i < this.getItemCount(); ++i) {
                    VWParticipant participant = this.getItemAt(i);
                    if (VWStringUtils.compare(participant.getParticipantName(), recipient.getParticipantName()) != 0) continue;
                    this.setSelectedIndex(i);
                    bFound = true;
                    break;
                }
            }
            if (!bFound) {
                DefaultListModel listModel = (DefaultListModel)this.m_resultsList.getModel();
                listModel.addElement(new VWParticipantItem(recipient));
                this.m_resultsList.setSelectedValue(recipient, true);
            }
        }
    }

    public boolean hasValidSelection() {
        return this.getSelectedIndex() != -1;
    }

    public void setEnabled(boolean bEnable) {
        if (this.m_itemFilterPanel != null) {
            this.m_itemFilterPanel.setEnabled(bEnable);
        }
        if (this.m_resultsList != null) {
            this.m_resultsList.setEnabled(bEnable);
        }
    }

    public void reset() {
        if (this.m_itemFilterPanel != null) {
            this.m_itemFilterPanel.clear();
        }
        if (this.m_resultsList != null) {
            this.updateUsers(null);
        }
    }

    public void removeReferences() {
        if (this.m_itemFilterPanel != null) {
            this.m_itemFilterPanel.removeActionListener(this);
            this.m_itemFilterPanel.removeReferences();
            this.m_itemFilterPanel = null;
        }
        if (this.m_resultsList != null) {
            this.m_resultsList.removeListSelectionListener(this);
            this.m_resultsList.setCellRenderer(null);
            this.m_resultsList = null;
        }
        this.m_parentContainer = null;
        this.m_vwSession = null;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_itemFilterPanel)) {
                this.updateUsers(this.m_itemFilterPanel.getUserParticipantItems());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), ex.getLocalizedMessage(), 1);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.m_resultsList)) {
            this.fireActionEvent(ACMD_SELECTION_CHANGED);
        }
    }

    public void focusGained(FocusEvent e) {
        int[] indices;
        JList list;
        Object source = e.getSource();
        if (source != null && source instanceof JList && (list = (JList)source).getModel().getSize() > 0 && ((indices = list.getSelectedIndices()) == null || indices.length == 0)) {
            list.setSelectedIndex(0);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    private void init() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.insets = new Insets(4, 4, 4, 4);
            gbCons.ipadx = 0;
            gbCons.ipady = 0;
            this.m_itemFilterPanel = new VWItemFilterPanel(this.m_parentContainer, this.m_vwSession);
            this.m_itemFilterPanel.addActionListener(this);
            this.add((Component)this.m_itemFilterPanel, gbCons);
            ++gbCons.gridy;
            gbCons.weighty = 1.0;
            gbCons.fill = 1;
            this.m_resultsList = new JList(new DefaultListModel());
            this.m_resultsList.setName("m_resultsList_VWRecipientFilterPanel");
            this.m_resultsList.setSelectionMode(0);
            this.m_resultsList.addListSelectionListener(this);
            this.m_resultsList.setCellRenderer(new VWRecipientListCellRenderer());
            VWAccessibilityHelper.setAccessibility(this.m_resultsList, this, VWResource.s_recipientsFilterList, VWResource.s_recipientsFilterList);
            this.m_resultsList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_resultsList.addFocusListener(this);
            this.add((Component)new JScrollPane(this.m_resultsList), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWParticipant getItemAt(int nIndex) {
        Object obj;
        if (this.m_resultsList != null && this.getItemCount() > nIndex && (obj = this.m_resultsList.getModel().getElementAt(nIndex)) != null && obj instanceof VWParticipantItem) {
            return ((VWParticipantItem)obj).getVWParticipant();
        }
        return null;
    }

    private int getSelectedIndex() {
        if (this.m_resultsList != null && this.getItemCount() > 0) {
            return this.m_resultsList.getSelectedIndex();
        }
        return -1;
    }

    private void setSelectedIndex(int nIndex) {
        if (this.m_resultsList != null && this.getItemCount() > nIndex) {
            this.m_resultsList.setSelectedIndex(nIndex);
        }
    }

    private void updateUsers(VWParticipantItem[] userItems) {
        DefaultListModel<VWParticipantItem> listModel = new DefaultListModel<VWParticipantItem>();
        if (userItems != null && userItems.length > 0) {
            for (int i = 0; i < userItems.length; ++i) {
                listModel.addElement(userItems[i]);
            }
        }
        this.m_resultsList.setModel(listModel);
        this.updateJListFocus();
    }

    private void fireActionEvent(String actionCommand) {
        this.updateJListFocus();
        ActionEvent event = new ActionEvent(this, 1001, actionCommand);
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    private void updateJListFocus() {
        boolean bFocusable;
        boolean bl = bFocusable = this.m_resultsList.getModel().getSize() != 0;
        if (bFocusable != this.m_resultsList.isFocusable()) {
            this.m_resultsList.setFocusable(bFocusable);
        }
    }
}

